/*
 * Decompiled with CFR 0.152.
 */
package org.agmas.harpymodloader.commands.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.doctor4t.wathe.api.Role;
import dev.doctor4t.wathe.api.WatheRoles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import org.agmas.harpymodloader.Harpymodloader;

public class RoleArgumentType
implements ArgumentType<Role> {
    public static final DynamicCommandExceptionType ROLE_EMPTY = new DynamicCommandExceptionType(input -> class_2561.method_43469((String)"argument.harpymodloader.role.notfound", (Object[])new Object[]{input}));
    public static final DynamicCommandExceptionType ROLE_MULTIPLE = new DynamicCommandExceptionType(input -> class_2561.method_43469((String)"argument.harpymodloader.role.found-multiple", (Object[])new Object[]{input}));
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private final boolean skipVanilla;

    public RoleArgumentType(boolean skipVanilla) {
        this.skipVanilla = skipVanilla;
    }

    public static RoleArgumentType skipVanilla() {
        return new RoleArgumentType(true);
    }

    public static RoleArgumentType create() {
        return new RoleArgumentType(false);
    }

    public static RoleArgumentType create(boolean skipVanilla) {
        return new RoleArgumentType(skipVanilla);
    }

    public static Role getRole(CommandContext<class_2168> context, String name) {
        return (Role)context.getArgument(name, Role.class);
    }

    public Role parse(StringReader reader) throws CommandSyntaxException {
        class_2960 roleId = null;
        String input = new StringReader(reader).readString();
        try {
            roleId = class_2960.method_12835((StringReader)reader);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        ArrayList<Role> matchRoles = new ArrayList<Role>();
        for (Role role : WatheRoles.ROLES) {
            if (this.skipVanilla && Harpymodloader.VANNILA_ROLES.contains(role) || !role.identifier().equals((Object)roleId) && !role.identifier().method_12832().startsWith(input)) continue;
            matchRoles.add(role);
        }
        if (matchRoles.isEmpty()) {
            throw ROLE_EMPTY.create((Object)input);
        }
        if (matchRoles.size() > 1) {
            throw ROLE_MULTIPLE.create((Object)input);
        }
        return (Role)matchRoles.getFirst();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9271(WatheRoles.ROLES.stream().filter(role -> !this.skipVanilla || !Harpymodloader.VANNILA_ROLES.contains(role)), (SuggestionsBuilder)builder, Role::identifier, Harpymodloader::getRoleName);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Serializer
    implements class_2314<RoleArgumentType, Properties> {
        public void writePacket(Properties properties, class_2540 buf) {
            buf.method_52964(properties.skipVanilla);
        }

        public Properties fromPacket(class_2540 buf) {
            return new Properties(buf.readBoolean());
        }

        public void writeJson(Properties properties, JsonObject json) {
            json.addProperty("skipVanilla", Boolean.valueOf(properties.skipVanilla));
        }

        public Properties getArgumentTypeProperties(RoleArgumentType argumentType) {
            return new Properties(argumentType.skipVanilla);
        }

        public class Properties
        implements class_2314.class_7217<RoleArgumentType> {
            private final boolean skipVanilla;

            public Properties(boolean skipVanilla) {
                this.skipVanilla = skipVanilla;
            }

            public RoleArgumentType createType(class_7157 commandRegistryAccess) {
                return new RoleArgumentType(this.skipVanilla);
            }

            public class_2314<RoleArgumentType, ?> method_41728() {
                return Serializer.this;
            }
        }
    }
}

